— Самая большая проблема вашего среза, — вещает седой, — в монотоварной и одновременно моноэкспортной экономике. Такая экономика характеризуется сильной зависимостью от продаж одного экспортного ресурса. Её структура, как правило, формируется там, где отсутствует диверсифицированная промышленная база, а внешняя торговля строится вокруг единственного товара. Обычно монотоварная экономика сырьевая, да и ваш город кажется исключением только на первый взгляд. Ваш экспорт выглядел высокотехнологичным, поскольку продаваемые изделия являются продукцией высокого передела…

— Простите, вы о чём вообще? — не выдерживаю я.

Шоня и остальные смотрят на меня с благодарностью, похоже они тоже нифига не поняли, просто стеснялись перебить.

— Я о так называемых «протеях», искусственных кибертелах, которые срез поставлял вовне, получая взамен сырьё, энергию и некие метаболические агенты, имеющие высокую обменную ценность.

— Это он про имплуху, что ли? — шепнула мне Козя.

— Типа того, ага.

— Поскольку «протеи» фантастически технологичны, у невнимательного эксперта возникает соблазн объявить «технологичным» сам экспорт, однако это в корне неверно. Поскольку производство имплотехники является для города артефактным, то фактически его экономика не производящая, а добывающая!

— Можно как-то раскрыть эту мысль? — попросила Шоня.

Я вижу, что ей неловко признаваться в том, что она недопонимает, но долг Верховной требует разобраться.

— Да, конечно, — кивнул внешник. — Дело в том, что производственный комплекс имплофабрик не является продуктом развития внутренних технологий города. Вы не изобрели кибернетические импланты и не построили заводы. Ваши далёкие предки нашли древние объекты в пустыне и поселились вокруг, построив на них первые башни. Так сформировалась аристократия этого среза, так называемые «Владетели», но о социальном аспекте мы поговорим в другой раз. Важнее то, что артефактные технологии, в отличие от автохтонных, не влекут за собой сопутствующего прогресса в других областях.

— Это как? — спросил я, чтобы не спрашивала Шоня.

— Поясню на примере. Город выпускает транспортные средства, например электромотоциклы, так?

— Моты? Ну да.

— Соответственно, он располагает технологией изготовления электродвигателей, батарей и электроники управления, что позволяет производить не только, как вы их называете «моты», но и электромобили, коптеры и так далее, то есть любые устройства той же технологической ветки. Это влечёт прогресс в смежных областях, то есть везде, где используются электрические моторы и управление ими: вентиляция и насосное хозяйство, например. А вот в производстве имплотехники город может лишь умеренно модифицировать изделия в пределах заложенной создателями фабрик вариативности, но не в состоянии сделать другую продукцию того же технологического уровня. Поэтому я и оцениваю моноэкспортную экономику города как «добывающую», а не «производящую». Ваши Владетели научились «добывать» имплокомплексы, догадавшись, куда надо сыпать сырьё, чтобы получить продукцию, но однажды попали в неизбежную ловушку так называемого «ресурсного проклятия».

— И что это такое?

Я задаю вопросы не потому, что мне интересно, нет. Просто вижу жалобные глаза Шони, которая не хочет позориться перед внешником и ребятами.

— Так называют слабое место моноэкономик: высокую уязвимость перед колебаниями цены или спроса на единственный их товар. Когда город потерял покупателя протеев, экономика моментально покатилась вниз. Несмотря на все усилия Креона, который, надо отдать ему должное, был прекрасным кризисным менеджером, преодолеть врождённое «ресурсное проклятие» ему не удалось. В результате возник критический дефицит энергии, а попытки его обойти привели к катастрофе Чёрного Тумана. На какое-то время ситуацию удалось стабилизировать за счёт экстренного перехода к сверхжёсткой планово-директивной экономике, построенной на гиперэксплуатации критично сократившихся трудовых ресурсов с использованием тех же артефактных технологий, так называемой «системе ренда». Она затормозила процессы распада общества, но её экстенсивность обрекала вас на неизбежное снижение жизненного уровня по мере деградации ключевой инфраструктуры, поддерживать которую на прежнем уровне стало невозможно. В конце концов сработал фактор риска, которому подвержены все директивные системы регуляции — кризис управления. Смерть Владетеля Креона привела к моментальной утере управленческих компетенций, а поскольку вся регуляторика шла в ручном режиме, то…

===

> продолжи в том же ключе и так же заумно

…то потеря единственного оператора системы неминуемо ведёт к коллапсу. Фактически, вы имеете дело не с государством в классическом понимании, а с гигантской, чрезвычайно сложной, но при этом хрупкой машиной, лишённой резервных контуров управления. Её устойчивость обеспечивалась не институтами, а харизмой и волей конкретного индивида, что в перспективе является заведомо проигрышной стратегией.

— Погодите, — поднимаю руку я, чувствуя, как Шоня мысленно благодарит меня за очередное вмешательство. — Вы говорите, будто всё держалось на Креоне одном. Но у него же был аппарат, управители, целые гильдии! Разве это не система?

Седой внешник делает паузу, доставая из складок плаща небольшой кристаллический планшет. На его поверхности вспыхивают сложные диаграммы.

— Формально — да. Но давайте рассмотрим суть. Аппарат, о котором вы говорите, был не управленческим классом в полном смысле, а скорее интерфейсом между волей Владетеля и артефактными системами. Их компетенции были узко специализированы и сводились к передаче приказов, мониторингу исполнения и локальному устранению сбоев согласно жёстким алгоритмам, также заложенным в артефакты. Они не принимали стратегических решений, не обладали целостным пониманием экономических процессов и, что критично, не имели легитимности на такие действия в глазах системы. Это высококвалифицированные операторы, но не самостоятельные субъекты управления. Их роль можно сравнить с ролью пилотов сверхсложного самолёта, которые мастерски умеют им управлять, но совершенно не знают, как его спроектировать или починить в случае фундаментальной поломки. Со смертью Креона исчез не просто руководитель — исчез единственный архитектор ежедневного баланса, единственный человек, чья ментальная модель всего среза хоть как-то соответствовала его действительной сложности.

Он переключает диаграмму. Теперь на экране что-то вроде нейросети, где один центральный узел был гигантским и излучал connections ко всем остальным, а те между собой были связаны слабо.

— Взгляните. Вот центральный узел — Креон. Вот периферийные — гильдии, управители, кланы. Видите плотность связей? Все нити сходятся к центру. Между периферийными узлами связи минимальны, они не обменивались существенными ресурсами или компетенциями напрямую, всё шло через центр. Такую систему в теории управления называют «звездообразной» или «радиальной». Её эффективность в стабильных условиях может быть очень высокой, но её устойчивость к потере центра стремится к нулю. Креон, осознанно или нет, выстроил идеальную машину исполнения, но не создал resilient-системы, способной к саморегуляции и адаптации. Более того, сама «система ренда», основанная на гиперконтроле и гиперэксплуатации, исключала возникновение таких горизонтальных связей и самостоятельных компетенций — они воспринимались бы как угроза целостности управления.

В комнате повисает тишина. Шоня смотрит на диаграмму с неприкрытым ужасом, наконец понимая масштаб пропасти, в которую катится город. Козя тихо свистит.

— Значит, выходит, всё было обречено с самого начала? — наконец спрашивает Шоня, забыв о позоре. — И «ресурсное проклятие», и эта… радиальная структура?

— Не совсем, — внешник гасит планшет. — Обречённость — не физический закон, а следствие выбранных траекторий. Город сделал ставку на артефакт как на чёрный ящик, дающий готовые решения, и на сильную руку, способную распределять эти решения. Это дало блестящий, но краткосрочный результат. Долгосрочной же стратегией могла бы стать попытка «вскрыть ящик» — не просто использовать, но и понять артефактные технологии, интегрировать их принципы в автохтонное знание, диверсифицировать экономику, создавая добавочную стоимость уже на своей интеллектуальной базе, и, что самое сложное, делегировать управленческую ответственность, создавая те самые горизонтальные связи. Но для этого нужны были иные приоритеты: не стабильность любой ценой здесь и сейчас, а инвестиции в неопределённое и рискованное будущее. Увы, логика «ресурсного проклятия» редко оставляет для таких манёвров пространство. Оно затягивает в воронку сиюминутной ренты, откладывая фундаментальные проблемы на потом. Пока не станет поздно.

Он смотрит на нас, и в его взгляде нет упрёка, только холодная аналитическая ясность.

— Ваш кризис, таким образом, носит тройственный характер: технологический (зависимость от непонятного артефакта), экономический (моноэкспорт и «ресурсное проклятие») и, наконец, управленческий (радиальная система, лишённая иммунитета к потере центра). Решать предстоит все три одновременно. И первый шаг — осознать, что вы не высокотехнологичная метрополия, переживающая временные трудности. Вы — сложноустроенное, но по сути добывающее сообщество, сидящее на остатках чужого технологического наследия, и это наследие заканчивается. Вопрос теперь в том, удастся ли вам до его окончания найти что-то своё.

— Поиск «чего-то своего», как вы выразились, упирается в фундаментальный парадокс, — продолжает внешник, складывая руки на груди. — Для того чтобы диверсифицировать экономику и развить автохтонные технологии, необходимы избыточные ресурсы — энергия, материалы, интеллектуальный капитал и, главное, время. Однако ваша текущая система «ренда» работает на пределе возможностей именно для того, чтобы добывать эти ресурсы для поддержания статус-кво, то есть для простого выживания артефактного производства и распределительных сетей. Это классическая ловушка воспроизводства: вся энергия уходит на поддержание системы, которая не оставляет энергии для её изменения.

Он делает паузу, давая нам осознать масштаб замкнутого круга.

— Креон это понимал. Его попытка создать «Проект Феникс» — ту самую секретную программу по обратному инжинирингу имплофабрик — была логичной. Но даже он, со всей своей властью, не смог выделить под это достаточных ресурсов, не подвергнув риску текущую стабильность. Программа велась в режиме «остаточного принципа», а в условиях кризиса была свёрнута одной из первых. Это иллюстрирует ещё один аспект «ресурсного проклятия»: оно не только делает экономику уязвимой, но и консервирует её структуру, убивая любые попытки качественного прыжка. Риск изменения начинает восприниматься системой как большая угроза, чем риск деградации.

Шоня медленно кивает, её лицо стало сосредоточенным. Она больше не смущается, а впитывает информацию, как губка.

— Так что же делать? Ждать, пока всё окончательно развалится, и начинать с нуля? — спрашивает она, и в её голосе звучит уже не растерянность, а холодная решимость Верховной.

— Это один из сценариев, — равнодушно отвечает внешник. — Наиболее вероятный, но и наиболее разрушительный. Полный коллапс инфраструктуры, демографическая катастрофа, потеря большей части накопленного — в том числе и того артефактного знания, которое ещё можно было бы использовать как трамплин. Альтернатива — попытаться осуществить управляемую трансформацию. Но для этого необходимо совершить три невозможных, на первый взгляд, действия.

Он поднимает три пальца.

— **Первое: создать избыток.** Нужно найти способ получить ресурсы, не завязанные на моноэкспорт и не отнимаемые у системы жизнеобеспечения. В истории подобных обществ этим ресурсом иногда становился внешний заём, но вам не у кого брать. Иногда — внутреннее «затягивание поясов» до критического уровня с направлением всех сил на один прорывной проект. Но ваш пояс и так затянут до предобморочного состояния. Остаётся третий вариант: «распаковать» имеющиеся артефактные активы иным способом. Не продавать готовые «протеи», а продавать *услуги* или *знания*, с ними связанные. Например, диагностику и кастомизацию чужих имплантов, использование ваших фабрик для штучного, высокоприбыльного производства по заказам извне, даже консалтинг по обращению со сложной кибернетикой. Это рискованно, но может создать тот самый первоначальный избыток.

— **Второе: делегировать и диверсифицировать когнитивно.** Даже если ресурсы появятся, некому будет их использовать. Нужно срочно ломать радиальную структуру. Это не значит немедленно свергать власть Верховной, — он с лёгким поклоном обращается к Шоне, — это значит создавать параллельные, горизонтальные центры компетенций. Восстановить или создать с нуля исследовательские гильдии, не подчинённые директивам ренда, а работающие на долгосрочные цели. Дать управителям реальную автономию в их секторах и стимулы к сотрудничеству друг с другом, минуя центр. По сути, вам нужно сознательно вырастить внутри умирающей системы новую, более живую и сложную, и надеяться, что она успеет окрепнуть до окончательного краха старой.

— И **третье: принять идею неудачи.** Жёстко спланированная трансформация обречена. Вы не можете знать, какой из новых путей окажется тупиковым, а какой — спасительным. Нужно запускать множество мелких, дешёвых экспериментов — в технологиях, в формах управления, в экономических моделях. Девять из десяти провалятся. Но один может дать тот самый ключ. Это требует толерантности к хаосу, которую ваша сверхжёсткая система была призвана искоренять. Это самая сложная часть: управляемый распад старого ради роста нового.

Он откидывается на спинку стула, и его седая голова на мгновение тонет в тени.

— Ваш срез, если отбросить романтику башен и имплантов, — это классический кейс поздней стадии ресурсной экономики с надстройкой в виде авторитарной системы управления, исчерпавшей свою адаптивность. Истории известны единичные случаи, когда таким обществам удавалось совершить переход. Все они связаны с сочетанием трёх факторов: появления харизматичного лидера-реформатора, готового ослабить собственную власть; наличия скрытого резерва — человеческого или технологического — который можно было мобилизовать; и, как это ни цинично, элемента везения. У вас есть только один из трёх — вы, верховная Шоня. Но одного лидера, даже самого решительного, недостаточно. Вам нужна команда, которая понимает суть проблемы не как «враги саботируют», а как «система нежизнеспособна по своим внутренним параметрам». И вам нужно чудо. В моём аналитическом отчёте этот пункт будет обозначен как «фактор X — низковероятное, но не невозможное стечение обстоятельств».


