Да, в PHP можно сделать вызов 

```php
Cache::redis()::keys('*')
```

Делается это так:

```php
class Cache {

    public static function redis():RedisHelper
    {
        return new RedisHelper();
    }
}

class RedisHelper {

    public static function keys(string $pattern = '*'):array
    {
        return 'something';
    }

    // только если мы хотим получить доступ к полям внешнего класса, их нужно инициализировать.
    // сначала создать метод инициализации
    // а потом вызвать его в конструкторе или ините родительского класса
    // ... или коннекторе 
    
    public static function init(\Arris\Toolkit\RedisClient $redis_connector, bool $is_redis_connected, LoggerInterface $logger): void
    {
        self::$logger = $logger;
        self::$is_redis_connected = $is_redis_connected;
        self::$redis = $redis_connector;
    }

}

```