```php
function getRoutingTable(array $routingRules): string
{
    $table = "<table border='1' cellpadding='5' cellspacing='0'>";
    $table .= "<thead><tr>
        <th>HTTP Method + Route</th>
        <th>Handler</th>
        <th>Name</th>
        <th>Before Middlewares</th>
        <th>After Middlewares</th>
    </tr></thead><tbody>";

    foreach ($routingRules as $route) {
        // HTTP Method + Route
        $methodRoute = "{$route['httpMethod']} {$route['route']}";
        
        // Handler
        $handler = '';
        if (is_array($route['handler']) && count($route['handler']) === 2) {
            $handler = "{$route['handler'][0]}@{$route['handler'][1]}";
        } elseif ($route['handler'] instanceof Closure) {
            $handler = 'Closure';
        } elseif (isset($route['handler']['__invoke'])) {
            $handler = 'Invokable Class';
        }
        
        // Name
        $name = $route['name'] ?? 'NULL';
        
        // Before Middlewares
        $beforeMiddlewares = [];
        foreach ($route['middlewares']['before'] as $middleware) {
            if (is_array($middleware) && count($middleware) === 2) {
                $beforeMiddlewares[] = "{$middleware[0]}@{$middleware[1]}";
            }
        }
        $beforeMiddlewaresStr = implode('<br>', $beforeMiddlewares) ?: 'None';
        
        // After Middlewares
        $afterMiddlewares = [];
        foreach ($route['middlewares']['after'] as $middleware) {
            if (is_array($middleware) {
                $afterMiddlewares[] = "{$middleware[0]}@{$middleware[1]}";
            }
        }
        $afterMiddlewaresStr = implode('<br>', $afterMiddlewares) ?: 'None';
        
        $table .= "<tr>
            <td>{$methodRoute}</td>
            <td>{$handler}</td>
            <td>{$name}</td>
            <td>{$beforeMiddlewaresStr}</td>
            <td>{$afterMiddlewaresStr}</td>
        </tr>";
    }
    
    $table .= "</tbody></table>";
    return $table;
}

// Использование:
echo getRoutingTable(AppRouter::getRoutingRules());
```