```php
function getRoutingTableText(array $routingRules): string
{
    $output = "HTTP Method + Route\tHandler\tName\tBefore Middlewares\tAfter Middlewares\n";
    $output .= str_repeat("-", 150) . "\n";
    
    foreach ($routingRules as $route) {
        // HTTP Method + Route
        $methodRoute = "{$route['httpMethod']} {$route['route']}";
        
        // Handler
        $handler = '';
        if (is_array($route['handler']) && count($route['handler']) === 2) {
            $handler = "{$route['handler'][0]}@{$route['handler'][1]}";
        } elseif ($route['handler'] instanceof Closure) {
            $handler = 'Closure';
        } elseif (isset($route['handler']['__invoke'])) {
            $handler = 'Invokable Class';
        }
        
        // Name
        $name = $route['name'] ?? 'NULL';
        
        // Before Middlewares
        $beforeMiddlewares = [];
        foreach ($route['middlewares']['before'] as $middleware) {
            if (is_array($middleware) && count($middleware) === 2) {
                $beforeMiddlewares[] = "{$middleware[0]}@{$middleware[1]}";
            }
        }
        $beforeMiddlewaresStr = implode(', ', $beforeMiddlewares) ?: 'None';
        
        // After Middlewares
        $afterMiddlewares = [];
        foreach ($route['middlewares']['after'] as $middleware) {
            if (is_array($middleware)) {
                $afterMiddlewares[] = "{$middleware[0]}@{$middleware[1]}";
            }
        }
        $afterMiddlewaresStr = implode(', ', $afterMiddlewares) ?: 'None';
        
        $output .= sprintf("%-40s %-40s %-15s %-30s %-30s\n",
            $methodRoute,
            $handler,
            $name,
            $beforeMiddlewaresStr,
            $afterMiddlewaresStr
        );
    }
    
    return $output;
}

// Использование:
echo getRoutingTableText(AppRouter::getRoutingRules());
```