# Настройка лога медленных запросов (Slow Query Log)

```
[mysqld]
slow_query_log = 1
slow_query_log_file = /var/log/mysql/mysql-slow.log
long_query_time = 1
log_queries_not_using_indexes = 1

; -- Включить общий лог запросов
general_log = 1

; -- Указать файл для общего лога
general_log_file = /var/log/mysql/mysql-query.log
```

# Проверка текущих настроек

```sql
SHOW VARIABLES LIKE '%slow_query_log%';
SHOW VARIABLES LIKE '%long_query_time%';
SHOW VARIABLES LIKE '%general_log%';
```

#  Анализ логов

```
mysqldumpslow /var/log/mysql/mysql-slow.log
```
или

```
pt-query-digest /var/log/mysql/mysql-slow.log
```

