Отличные данные! Вот подробный анализ и сравнительная таблица:

## **Анализ результатов**

### **Исходный файл:** 47news.sql = 1,04 GiB (1111885684 байт)

## **Сравнительная таблица**

| Метод сжатия | Команда | Время (real) | Размер (байт) | Степень сжатия | Скорость (MiB/s) | CPU нагрузка |
|--------------|---------|--------------|---------------|----------------|------------------|--------------|
| **Исходный** | - | - | 1,111,885,684 | 0% | - | - |
| **gzip (1)** | `gzip -c` | 0:54 | 257,271,058 | 76.8% | 19.6 | умеренная |
| **gzip (9)** | `gzip -c -9` | 2:01 | 252,694,481 | 77.3% | 8.79 | высокая |
| **pigz (1)** | `pigz -c` | 0:06 | 257,703,551 | 76.8% | 172 | очень высокая |
| **pigz (9)** | `pigz -c -9` | 0:12 | 253,075,037 | 77.2% | 86.5 | очень высокая |
| **bzip2 (1)** | `bzip2 -c` | 1:09 | 163,078,834 | 85.3% | 15.4 | высокая |
| **bzip2 (9)** | `bzip2 -c -9` | 1:08 | 163,078,834 | 85.3% | 15.5 | высокая |
| **xz (1)** | `xz -c` | 0:54 | 142,393,068 | 87.2% | 26.2 | очень высокая |
| **xz (9)** | `xz -c -9` | 1:47 | 128,962,872 | 88.4% | 3.03* | очень высокая |
| **zstd (1)** | `zstd -c` | 0:01 | 239,551,209 | 78.5% | 823 | высокая |
| **zstd (T0)** | `zstd -c -T0` | 0:01 | 239,551,209 | 78.5% | 1330 | очень высокая |
| **zstd (19)** | `zstd -c -19 --ultra` | 3:33 | 141,769,237 | 87.2% | 5.50 | экстремальная |
| **zstd (T0,19)** | `zstd -c -T0 -19 --ultra` | 2:03 | 141,769,237 | 87.2% | 10.6 | экстремальная |

\* *xz -9 показывает 3.03 GiB/s в pv, но реальная скорость обработки ~10.4 MiB/s*

## **Ключевые выводы**

### **По скорости (быстрее → медленнее):**
1. **zstd -T0** (0.8 сек) - абсолютный лидер скорости
2. **zstd** (1.3 сек) - почти так же быстро
3. **pigz** (6-12 сек) - многопоточный gzip
4. **gzip/xz базовый** (~54 сек)
5. **bzip2** (~68 сек)
6. **zstd максимальное** (2-3.5 мин)

### **По степени сжатия (лучше → хуже):**
1. **xz -9** (88.4%) - лучший размер
2. **zstd -19 / xz -1** (87.2%) - отличное сжатие
3. **bzip2** (85.3%) - хорошее сжатие
4. **zstd -1** (78.5%) - умеренное
5. **gzip/pigz** (76.8-77.3%) - базовое

### **По эффективности CPU:**
- **pigz/zstd -T0** - максимально используют CPU, быстрее
- **zstd -19** - экстремальная нагрузка (10 мин CPU на 2 мин реального времени)
- **gzip** - сбалансированная нагрузка

## **Рекомендации по использованию:**

### **Для ежедневного использования:**
- **zstd -T0** - если установлен, идеальный баланс
- **pigz** - если нужна совместимость с gzip

### **Для максимального сжатия:**
- **xz -9** - если можно ждать и важен каждый байт
- **zstd -19** - если нужен баланс сжатия/распаковки

### **Для максимальной совместимости:**
- **gzip** - работает везде
- **bzip2** - хорошая альтернатива

### **Для SQL дампов:**
```bash
# Быстрое сжатие для частых бэкапов
mysqldump db | pv | zstd -T0 > backup.sql.zst

# Максимальное сжатие для архивных копий
mysqldump db | pv | xz -9 > backup.sql.xz
```

**Итог:** zstd на уровне по умолчанию показывает феноменальную скорость при хорошем сжатии, делая его лучшим выбором для большинства задач.