# Подробный список всех привилегий для всех пользователей

```sql
SELECT 
    grantee, 
    table_schema, 
    privilege_type 
FROM 
    information_schema.schema_privileges 
ORDER BY 
    grantee, table_schema;
```

# Альтернативный вариант с объединением информации
```sql
SELECT 
    u.user, 
    u.host, 
    db.db, 
    db.select_priv, 
    db.insert_priv, 
    db.update_priv, 
    db.delete_priv, 
    db.create_priv, 
    db.drop_priv, 
    db.grant_priv 
FROM 
    mysql.user u 
LEFT JOIN 
    mysql.db db ON u.user = db.user AND u.host = db.host 
WHERE 
    db.db IS NOT NULL 
ORDER BY 
    u.user, u.host, db.db;
```
