Ключевые различия

```
#!/usr/bin/make
SHELL = bash
INSTALL_DIR = example
PATH_PROJECT = $(DESTDIR)/var/www/$(INSTALL_DIR)

install: 	##@system Install package. Don't run it manually!!!
	@echo Installing...
	install -d $(PATH_PROJECT)
	cp -r public $(PATH_PROJECT)
	cp README.md $(PATH_PROJECT)
```
В этом случае в INSTALL_DIR копируется папка `public`. Будет примерно так: `/var/www/example/public/index.html`

```
install: 	##@system Install package. Don't run it manually!!!
	@echo Installing...
	install -d $(PATH_PROJECT)
	cp -r public/* $(PATH_PROJECT)
	cp README.md $(PATH_PROJECT)
```
А в этом случае в INSTALL_DIR копируется содержимое папки public. Это удобнее, если это чистый статический HTML. 
Будет примерно так:

`/var/www/example/index.html`
